/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;

public class UploadManager
extends Thread {
    File[] files;
    Main main;
    URL destination;
    private int maxThreads = 5;
    private UploadThread[] upThreads;

    public UploadManager(File[] f, Main m, URL d) {
        this.files = f;
        this.main = m;
        this.destination = d;
    }

    public UploadManager(File[] f, Main m, URL d, int max) {
        try {
            if (max > 5 || max < 1) {
                max = 5;
            }
            this.maxThreads = max;
        }
        catch (NullPointerException npe) {
            this.maxThreads = 5;
        }
        this.files = f;
        this.main = m;
        this.destination = d;
    }

    public void cancelUpload() {
        for (int i = 0; i < this.files.length; ++i) {
            this.upThreads[i].cancelUpload();
        }
    }

    public void run() {
        this.upThreads = new UploadThread[this.files.length];
        for (int i = 0; i < this.files.length; i += this.maxThreads) {
            int j;
            for (j = 0; j < this.maxThreads && i + j < this.files.length; ++j) {
                try {
                    this.upThreads[i + j] = new UploadThread(this.destination, this.files[i + j], this.main);
                    this.upThreads[i + j].start();
                    continue;
                }
                catch (UnknownHostException uhe) {
                    System.out.println("*** UnknownHostException: UploadManager ***");
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println("*** IOException: UploadManager ***");
                }
            }
            while (this.upThreads[i + j - 1].isAlive()) {
            }
        }
    }

    private void urlFailure() {
    }
}

